% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_duration_summary.R
\name{sequence_duration_summary}
\alias{sequence_duration_summary}
\title{Summarize Sequence Durations}
\usage{
sequence_duration_summary(sequences, start_time, end_time, duration = NULL)
}
\arguments{
\item{sequences}{A character vector where each element is a sequence of elements separated by spaces.}

\item{start_time}{A numeric vector representing the start times of the sequences.}

\item{end_time}{A numeric vector representing the end times of the sequences.}

\item{duration}{(Optional) A numeric vector representing the durations of the sequences. If `NULL`, it will be calculated as `end_time - start_time`.}
}
\value{
A data frame with the following columns:
\item{mean_seq_duration}{The mean duration of the sequences.}
\item{sd_seq_duration}{The standard deviation of the sequence durations.}
\item{median_seq_duration}{The median duration of the sequences.}
\item{min_seq_duration}{The minimum duration of the sequences.}
\item{max_seq_duration}{The maximum duration of the sequences.}
}
\description{
This function calculates summary statistics for the durations of sequences, where the duration is defined as the difference between `end_time` and `start_time`. If `duration` is provided, it will be used directly.
}
\examples{
sequences <- c('hello world', 'hello world hello', 'hello world hello world')
start_time <- c(1, 2, 3)
end_time <- c(2, 4, 7)
sequence_duration_summary(sequences, start_time, end_time)
}
