% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor_prediction.R
\name{anchor_prediction}
\alias{anchor_prediction}
\title{anchor_prediction}
\usage{
anchor_prediction(anchor_model, x, anchor, gamma, target_variable)
}
\arguments{
\item{anchor_model}{is the Anchor Regression model object}

\item{x}{is a dataframe containing the matrix x containing the independent variables}

\item{anchor}{is a dataframe containing the matrix anchor containing the anchor variable}

\item{gamma}{is the regularization parameter for the Anchor Regression}

\item{target_variable}{is the target variable name contained in the x dataframe}
}
\value{
A list of predictions.
}
\description{
Perform a prediction for an Anchor Regression model as described in Rothenhäusler et al.2020
}
\examples{
x <- as.data.frame(matrix(data = rnorm(100),nrow = 100,ncol = 10))
anchor <- as.data.frame(matrix(data = rnorm(200),nrow = 100,ncol = 2))
colnames(anchor) <- c('X1','X2')
gamma <- 2
target_variable <- 'V2'
anchor_model <- anchor_regression(x, anchor, gamma, target_variable)
anchor_prediction(anchor_model$model, x, anchor, gamma, target_variable)
}
