% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Models.R
\name{MLEAO}
\alias{MLEAO}
\title{Accelerated Odds (AO) Model.}
\usage{
MLEAO(
  init,
  times,
  status,
  n,
  basehaz,
  z,
  method = "BFGS",
  hessian = TRUE,
  conf.int = 0.95,
  maxit = 1000,
  log = FALSE
)
}
\arguments{
\item{init}{: Initial parameters to maximize the likelihood function;}

\item{times}{: survival times}

\item{status}{: vital status (1 - dead, 0 - alive)}

\item{n}{: The number of the data set}

\item{basehaz}{: baseline hazard structure including baseline (New generalized log-logistic accelerated odds "NGLLAO" model,  generalized log-logisitic accelerated odds "GLLAO" model,
modified log-logistic accelerated odds "MLLAO" model,exponentiated Weibull accelerated odds "EWAO" model,
power generalized weibull accelerated odds "PGWAO" model, generalized gamma accelerated odds "GGAO" model,
modified kumaraswamy Weibull accelerated odds "MKWAO" model, log-logistic accelerated odds "LLAO" model,
tangent-log-logistic accelerated odds "TLLAO" model, sine-log-logistic accelerated odds "SLLAO" model,
cosine log-logistic accelerated odds "CLLAO" model,secant-log-logistic accelerated odds "SCLLAO" model,
arcsine-log-logistic accelerated odds "ASLLAO" model,arctangent-log-logistic accelerated odds "ATLLAO" model,
Weibull accelerated odds "WAO" model, gamma accelerated odds "WAO" model, and log-normal accelerated odds "ATLNAO" model.)}

\item{z}{: design matrix for covariates (p x n), p >= 1}

\item{method}{:"optim" or a method from "nlminb".The methods supported are: BFGS (default), "L-BFGS", "Nelder-Mead", "SANN", "CG", and "Brent".}

\item{hessian}{:A function to return (as a matrix) the hessian for those methods that can use this information.}

\item{conf.int}{: confidence level}

\item{maxit}{:The maximum number of iterations. Defaults to 1000}

\item{log}{:log scale (TRUE or FALSE)}
}
\value{
a list containing the output of the optimisation (OPT) and the log-likelihood function (loglik)
}
\description{
A Tractable Parametric Accelerated Odds (AO) model's maximum likelihood estimates,log-likelihood, and Information Criterion values.
 Baseline hazards: NGLL,GLL,MLL,PGW, GG, EW, MKW, LL, TLL, SLL,CLL,SCLL,ATLL, and ASLL
}
\examples{

#Example #1
data(alloauto)
time<-alloauto$time
delta<-alloauto$delta
z<-alloauto$type
MLEAO(init = c(1.0,0.40,0.50,0.50),times = time,status = delta,n=nrow(z),
basehaz = "GLLAO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #2
data(bmt)
time<-bmt$Time
delta<-bmt$Status
z<-bmt$TRT
MLEAO(init = c(1.0,1.0,0.5),times = time,status = delta,n=nrow(z),
basehaz = "CLLAO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,
log=FALSE)

#Example #3
data("gastric")
time<-gastric$time
delta<-gastric$status
z<-gastric$trt
MLEAO(init = c(1.0,1.0,0.5),times = time,status = delta,n=nrow(z),
basehaz = "LNAO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

#Example #4
data("larynx")
time<-larynx$time
delta<-larynx$delta
larynx$age<-as.numeric(scale(larynx$age))
larynx$diagyr<-as.numeric(scale(larynx$diagyr))
larynx$stage<-as.factor(larynx$stage)
z<-model.matrix(~ stage+age+diagyr, data = larynx)
MLEAO(init = c(1.0,1.0,0.5,0.5,0.5,0.5,0.5,0.5),times = time,status = delta,n=nrow(z),
basehaz = "ASLLAO",z = z,method = "BFGS",hessian=TRUE, conf.int=0.95,maxit = 1000,log=FALSE)

}
\author{
Abdisalam Hassan Muse, Samuel Mwalili, Oscar Ngesa, Christophe Chesneau  \email{abdisalam.hassan@amoud.edu.so}
}
