# AlgeriAPIs - Access Algerian Data via Public APIs
# Version 0.1.0
# Copyright (c) 2025 Renzo Caceres Rossi
# Licensed under the MIT License.
# See the LICENSE file in the root directory for full license text.

# internet_users_tbl_df

library(testthat)

# Test 1: Confirm the object is a tibble with spec_tbl_df class
test_that("internet_users_tbl_df is a tibble with spec_tbl_df class", {
  expect_s3_class(internet_users_tbl_df, "spec_tbl_df")
  expect_s3_class(internet_users_tbl_df, "tbl_df")
  expect_s3_class(internet_users_tbl_df, "tbl")
  expect_s3_class(internet_users_tbl_df, "data.frame")
})

# Test 2: Confirm it has exactly 6 columns
test_that("internet_users_tbl_df has 6 columns", {
  expect_equal(length(internet_users_tbl_df), 6)
})

# Test 3: Confirm it has exactly 32 rows
test_that("internet_users_tbl_df has 32 rows", {
  expect_equal(nrow(internet_users_tbl_df), 32)
})

# Test 4: Confirm column names are correct and in order
test_that("internet_users_tbl_df has correct column names", {
  expect_named(internet_users_tbl_df, c(
    "Year", "Algeria", "Maghreb_union", "Arab_world",
    "European_Union", "The_World"
  ))
})

# Test 5: Confirm column types are correct
test_that("internet_users_tbl_df columns have correct types", {
  expect_type(internet_users_tbl_df$Year, "double")
  expect_type(internet_users_tbl_df$Algeria, "double")
  expect_type(internet_users_tbl_df$Maghreb_union, "double")
  expect_type(internet_users_tbl_df$Arab_world, "double")
  expect_type(internet_users_tbl_df$European_Union, "double")
  expect_type(internet_users_tbl_df$The_World, "double")
})
