% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ChangeTimeVar.R
\name{ChangeTimeVar}
\alias{ChangeTimeVar}
\title{Reformat Time Variable}
\usage{
ChangeTimeVar(datain, col_idx, format = "\%Y-\%m-\%d \%H:\%M:\%S")
}
\arguments{
\item{datain}{input dataset, must be a data frame}

\item{col_idx}{index of column to convert to date object}

\item{format}{format of input date data, default is YYYY-MM-DD HH:MM:SS}
}
\value{
dataframe with formatted time values
}
\description{
Reformat the time variable to match analysis-ready format
}
\examples{
data("SleepDiary1Week")

ChangeTimeVar(
SleepDiary1Week,
col_idx = c(5:18),
format = "\%Y-\%m-\%d \%H:\%M:\%S")

}
