% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excursion.R
\name{excursion}
\alias{excursion}
\title{Temperature Excursion}
\usage{
excursion(
  step1_down_object,
  temp_changes,
  time_changes,
  CI = TRUE,
  PI = TRUE,
  draw = 10000,
  confidence_interval = 0.95,
  intercept = NULL,
  ribbon = TRUE,
  xname = NULL,
  yname = NULL,
  plot_simulations = FALSE
)
}
\arguments{
\item{step1_down_object}{The fit object from the step1_down function (required).}

\item{temp_changes}{A list that represents the order of the temperatures that
the product is subjected to. Must be the same length as time_changes.}

\item{time_changes}{List that represents the times at which the temperature changes,
Starts from time zero and must be the same length as temp_changes.}

\item{CI}{Show confidence intervals.}

\item{PI}{Show prediction intervals.}

\item{draw}{Number of simulations used to estimate confidence intervals.}

\item{confidence_interval}{Confidence level for the confidence and prediction intervals
around the predictions (default 0.95).}

\item{intercept}{Use a forced y-intercept. If null, the fitted value (of c0) will be used.}

\item{ribbon}{Add shading to confidence and prediction intervals (optional).}

\item{xname}{Label for the x-axis (optional).}

\item{yname}{Label for the y-axis (optional).}

\item{plot_simulations}{If TRUE, randomly selects 100 of the simulations to
also display on the plot.}
}
\value{
An SB class object, a list including the following elements:
\itemize{
\item \emph{prediction} - A data frame containing the predictions with the confidence and prediction intervals.
\item \emph{simulations} - Matrix of the simulations.
\item \emph{excursion plot} - A plot with predictions and statistical intervals.
\item \emph{user_parameters} - List of users input parameters which is utilised by other
functions in the package.
}
}
\description{
Predict a temperature excursion for a product.
}
\details{
Use the output from step1.down to run a temperature excursion prediction.
}
\examples{
#load antigenicity
data(antigenicity)

#run step1.down fit
fit1 <- step1_down(data = antigenicity, y = "conc", .time = "time",
 C = "Celsius", max_time_pred = 3)

#run excursion function with fixed intercept.
excursion <- excursion(step1_down_object = fit1,
                       temp_changes = c(5,15,10),
                       time_changes = c(0.5,1.5,3),
                       CI = TRUE, PI = TRUE, draw = 4000,
                       confidence_interval = 0.95,
                       intercept = 80,
                       xname = "Time in years", yname = "Concentration",
                       ribbon = TRUE, plot_simulations = TRUE)

excursion$excursion_plot

}
