% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat62}
\alias{simDat62}
\title{Simulate data for Chapter 6.2: Two groups with equal variance}
\usage{
simDat62(n1 = 60, n2 = 40, mu1 = 105, mu2 = 77.5, sigma = 2.75)
}
\arguments{
\item{n1}{The sample size of females}

\item{n2}{The sample size of males}

\item{mu1}{The population mean males}

\item{mu2}{The population mean females}

\item{sigma}{The standard deviation for both groups}
}
\value{
A list of simulated data and parameters.
  \item{n1}{Female sample size}
  \item{n2}{Male sample size}
  \item{mu1}{Female mean}
  \item{mu2}{Male mean}
  \item{beta}{Difference in wingspan mean between sexes}
  \item{sigma}{Standard deviation for both groups}
  \item{x}{Indicator variable for sex, 1 = male}
  \item{y}{Simulated wingspan data}
}
\description{
Simulate wingspan measurements in female and male peregrines with equal variance.
}
\examples{
str(dat <- simDat62())      # Implicit default arguments
str(dat <- simDat62(n1 = 1000, n2 = 10000)) # Much larger sample sizes

# Revert to "model-of-the-mean" (with larger sample size)
str(dat <- simDat62(n1 = 10000, n2 = 10000, mu1 = 105, mu2 = 105))

}
\author{
Marc Kéry
}
