% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat4}
\alias{simDat4}
\title{Simulate data for Chapter 4: Model of the mean}
\usage{
simDat4(n = 10, mean = 600, sd = 30)
}
\arguments{
\item{n}{The sample size}

\item{mean}{Population mean}

\item{sd}{Population standard deviation}
}
\value{
A list of simulated data and parameters.
  \item{n}{Sample size}
  \item{mean}{Population mean}
  \item{sd}{Population SD}
  \item{y}{Simulated peregrine mass measurements}
}
\description{
Simulate body mass measurements for n peregrine falcons
from a normal distribution with population mean = 'mean' and population sd = 'sd'
}
\examples{
str(dat <- simDat4())          # Implicit default arguments
str(dat <- simDat4(n = 10^6))  # More than the world population of peregrines
str(dat <- simDat4(n = 10, mean = 900, sd = 40))  # Simulate 10 female peregrines

}
\author{
Marc Kéry
}
