% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_update_gpc_parallel.R
\name{predict_update_gpc_parallel}
\alias{predict_update_gpc_parallel}
\title{Quick update of conditional variances when one or many new points are added to the DoE.}
\usage{
predict_update_gpc_parallel(Sigma.r, newdata.oldsd, kn)
}
\arguments{
\item{Sigma.r}{an r*r conditional covariance matrix at r points \code{newX}(x_(n+1),...,x_(n+r)). It represents the covariance matrix \code{cov} obtained through the \code{\link[GPCsign]{predict}} function at \code{newX}.}

\item{newdata.oldsd}{conditional standard deviations vector at the points \code{newdata}, (before adding x_(n+1),...,x_(n+r)).}

\item{kn}{conditional covariances between the points \code{newdata} and the r points \code{newX}.}
}
\value{
a list with:
\item{sd}{updated conditional standard deviation at points \code{newdata}.}
\item{lambda}{new GPC weight of x_(n+1),...,x_(n+r) for the prediction at points \code{newdata}.}
}
\description{
The functions uses Gaussian Process Classification (GPC) update formulas to quickly compute conditional variances at points newdata, when \code{r} new points \code{newX} are added.
}
\examples{
#-------------------------------------------------------------------
#------------------- predict_update_gpc_parallel -------------------
#-------------------------------------------------------------------

## 20-points DoE, and the corresponding response
d <- 2
nb_PX <- 20
x <- matrix(c(0.205293785978832, 0.0159983370750337,
              0.684774733109666, 0.125251417595962,
              0.787208786290006, 0.700475706055049,
              0.480507717105934, 0.359730889653793,
              0.543665267336735, 0.565974761807069,
              0.303412043992361, 0.471502352650857,
              0.839505250127309, 0.504914690245002,
              0.573294917143728, 0.784444726564573,
              0.291681289223421, 0.255053812451938,
              0.87233450888786, 0.947168337730927,
              0.648262257638515, 0.973264712407035,
              0.421877310273815, 0.0686662506387988,
              0.190976166753807, 0.810964668176754,
              0.918527262507395, 0.161973686467513,
              0.0188128700859558, 0.43522031347403,
              0.99902788789426, 0.655561821513544,
              0.741113863862512, 0.321050086076934,
              0.112003007565305, 0.616551317575545,
              0.383511473487687, 0.886611679106771,
              0.0749211435982952, 0.205805968972305),
            byrow = TRUE, ncol = d)
require(DiceKriging)
fx <- apply(x, 1, branin)
f <- ifelse(fx < 14, -1, 1)
Xf <- as.matrix(x)

require(future)
plan(multisession)

## gpcm object
require(GPCsign)
model <- gpcm(f, Xf, coef.m = -1.25, coef.cov = c(1.17,0.89))

##
n.grid <- 20
x.grid <- seq(0,1,length=n.grid)
newdata <- expand.grid(x.grid,x.grid)
newdata <- as.matrix(newdata)
pred1 <- predict(object=model,newdata=newdata)
precalc.data <- list()
precalc.data$c.K <- crossprod(pred1$c, model@invK)
newdata.oldsd <- sqrt(pred1$Zsimu_var)

# new points added
new.x <- matrix(c(0.1,0.2),ncol=2)

# predicion at new points
pred2 <- predict(object=model,newdata=new.x)
Sigma.r <- pred2$cov

newdata <- scale(x = newdata, center = model@X.mean, scale = model@X.std)
new.x <- scale(x = new.x, center = model@X.mean, scale = model@X.std)
kn <- computeQuickgpccov(object = model,
                         integration.points = newdata,
                         X.new = new.x,
                         precalc.data = precalc.data,
                         c.newdata = pred2$c)

updated.predictions <- predict_update_gpc_parallel(Sigma.r = Sigma.r,
                                                   newdata.oldsd = newdata.oldsd,
                                                   kn = kn)
plan(sequential)

}
\references{
Menz, M., Munoz-Zuniga, M., Sinoquet, D. Estimation of simulation failure set with active learning based on Gaussian Process classifiers and random set theory (2023). \url{https://hal.science/hal-03848238}.

Chevalier, C., Ginsbourger, D. (2014). Corrected Kriging update formulae for batch-sequential data assimilation, in Pardo-Iguzquiza, E., et al. (Eds.) \emph{Mathematics of Planet Earth}, pp 119-122
}
\author{
Morgane MENZ, Delphine SINOQUET, Miguel MUNOZ-ZUNIGA. Contributors: Naoual SERRAJI.
}
