% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALTopt.R
\name{pv.fus.rc}
\alias{pv.fus.rc}
\title{FUS (Fraction of Use Space) plot for right censoring.}
\usage{
pv.fus.rc(
  design,
  tc,
  nf,
  alpha,
  formula,
  coef,
  useLower = NULL,
  useUpper = NULL
)
}
\arguments{
\item{design}{the data frame containing the coordinates and the number of
allocation of each design point. The design created by either
\code{\link{altopt.rc}} or \code{\link{altopt.ic}} or any design matrix
with the same form as those can be provided for this argument.}

\item{tc}{the censoring time.}

\item{nf}{the number of stress factors.}

\item{alpha}{the value of the shape parameter of Weibull distribution.}

\item{formula}{the object of class formula which is the linear predictor model.}

\item{coef}{the numeric vector containing the coefficients of each term in \code{formula}.}

\item{useLower, useUpper}{the vectors containing the lower bound and upper
bound for the use region. They should be provided for FUS plot.}
}
\value{
The "trellis" object which includes the FUS plot
  for right censoring.
}
\description{
\code{\link{pv.fus.rc}} draws the FUS plot of prediction variance
for a given design with right censoring plan. The use region
(\code{useLower} and \code{useUpper}) should be
provided.
}
\examples{
\dontrun{
# FUS plot of I optimal design with right censoring.
Design <- altopt.rc("I", 100, 100, 2, 1, formula = ~ x1 + x2 + x1:x2,
coef = c(0, -4.086, -1.476, 0.01), useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))

pv.fus.rc(Design$opt.design.rounded, 100, 2, 1,
formula = ~ x1 + x2 + x1:x2, coef = c(0, -4.086, -1.476, 0.01),
useLower = c(1.458, 2.859), useUpper = c(2.058, 3.459))
}
}
\seealso{
\code{\link{altopt.rc}}
}
