% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALLSPICE.R
\name{ALLSPICE}
\alias{ALLSPICE}
\title{ALLSPICE}
\usage{
ALLSPICE(
  data,
  pheno_corr,
  n_ind,
  gene = "GENENAME",
  pheno1 = "PHENO1",
  pheno2 = "PHENO2",
  beta1_field = "BETA1",
  beta2_field = "BETA2",
  af_field = "AF"
)
}
\arguments{
\item{data}{Input data with number of rows indicating number of variants, three columns are required:
1) effect sizes of variants for phenotype 1, 2) effect sizes of variants for phenotype 2, 3) allele frequency of variants
Note: this should include variants from ONE gene that is associated with the two phenotypes,
preferably of the SAME functional category after being filtered to variants with allele frequency below a certain threshold (e.g. 1e-4)}

\item{pheno_corr}{phenotypic correlation between the two phenotypes being tested}

\item{n_ind}{total number of individuals}

\item{gene}{name of the gene being tested, default `GENENAME`}

\item{pheno1}{descriptive name of phenotype 1, default `PHENO1`}

\item{pheno2}{descriptive name of phenotype 2, default `PHENO2`}

\item{beta1_field}{field name for effect sizes of variants on phenotype 1, default `BETA1`}

\item{beta2_field}{field name for effect sizes of variants on phenotype 2, default `BETA2`}

\item{af_field}{field name for allele frequencies of variants, default `AF`}
}
\value{
A list of summary statistics from ALLSPICE test
including phenotype names, gene names, MLE of slope c, ALLSPICE test statistic - lambda, pvalue from a chi-square distribution, total number of variants being tested
}
\description{
ALLSPICE (ALLelic Spectrum of Pleiotropy Informed Correlated Effects)
}
\examples{
data <- data.frame(x = rnorm(10), y = rnorm(10), z = runif(10, 0,1))
ALLSPICE(data,pheno_corr=0.5,n_ind=10000,beta1_field='x',beta2_field='y',af_field='z')
}
