% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{param_uncertainty}
\alias{param_uncertainty}
\title{Compute 95\% confidence interval}
\usage{
param_uncertainty(
  param_est,
  I_q_cur,
  B_cur = NA,
  A_neg,
  index_q,
  I_o_q_2_ori,
  q_ori_ring_loc_unique_index,
  sz,
  len_t,
  d_input,
  q,
  model_name,
  estimation_method = "asymptotic",
  M,
  num_iteration_max,
  lower_bound,
  msd_fn = NA,
  msd_grad_fn = NA
)
}
\arguments{
\item{param_est}{a vector of natural logarithm of estimated parameters from
maximize the log likelihood. This vector will serve as initial values in the
\code{optim} function.}

\item{I_q_cur}{Fourier transformed intensity profile}

\item{B_cur}{current value of B. This parameter is determined by the noise
in the system. See 'References'.}

\item{index_q}{selected index of wave number}

\item{I_o_q_2_ori}{absolute square of Fourier transformed intensity profile,
ensemble over time}

\item{q_ori_ring_loc_unique_index}{index for wave vector that give unique frequency}

\item{sz}{frame size of the intensity profile}

\item{len_t}{number of time steps}

\item{d_input}{sequence of lag times}

\item{q}{wave vector in unit of um^-1}

\item{model_name}{model name for the fitted model, options from ('BM','OU',
'FBM',OU+FBM','user_defined')}

\item{estimation_method}{method for constructing 95\% confidence interval,
default is asymptotic}

\item{M}{number of particles}

\item{num_iteration_max}{the maximum number of iterations in \code{optim}}

\item{lower_bound}{lower bound for the "L-BFGS-B" method in \code{optim}}

\item{msd_grad_fn}{user defined MSD gradient structure,  a function of
\code{param} and \code{d_input}}
}
\value{
A matrix of lower and upper bound for natural logarithm of
parameters in the fitted model using \code{AIUQ} method in \code{SAM} class
}
\description{
This function construct the lower and upper bound for 95\% confidence interval
of estimated parameters for the given model, including parameters contained
in the intermediate scattering function and background noise. See 'References'.
}
\references{
Gu, M., He, Y., Liu, X., & Luo, Y. (2023). Ab initio uncertainty
quantification in scattering analysis of microscopy.
arXiv preprint arXiv:2309.02468.

Gu, M., Luo, Y., He, Y., Helgeson, M. E., & Valentine, M. T. (2021).
Uncertainty quantification and estimation in differential dynamic microscopy.
Physical Review E, 104(3), 034610.

Cerbino, R., & Trappe, V. (2008). Differential dynamic microscopy: probing
wave vector dependent dynamics with a microscope. Physical review letters,
100(18), 188102.
}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
