% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{intensity_format_transform}
\alias{intensity_format_transform}
\title{Transform intensity profile into SS_T matrix}
\usage{
intensity_format_transform(intensity, intensity_str, square = FALSE, sz = NA)
}
\arguments{
\item{intensity}{intensity profile, array or matrix}

\item{intensity_str}{structure of the original intensity
profile, options from ('SST_array','T_SS_mat','SS_T_mat','S_ST_mat')}

\item{square}{a logical evaluating to TRUE or FALSE indicating whether or not
to crop each frame into a square such that frame size in x direction equals
frame size in y direction with \code{sz_x=sz_y}}

\item{sz}{frame size of each frame. A vector of length 2 with frame size in
y/(row) direction, and frame size in x/(column) direction, with default \code{NA}.}
}
\value{
A matrix of transformed intensity profile.
}
\description{
Transform intensity profile with different formats, ('SST_array','T_SS_mat',
'SS_T_mat','S_ST_mat'), space by space by time array, time by (space by space) matrix,
(space by space) by time matrix, or space by (space by time) matrix, into
'SS_T_mat'. In addition, crop each frame with odd frame size.
}
\examples{
library(AIUQ)
# -------------------------------------------------
# Example 1: Transform T_SS_mat into SS_T_mat, each
#             frame contains number 1-9
# -------------------------------------------------
(m <- matrix(rep(1:9,4),4,9,byrow=TRUE))
intensity_format_transform(m,intensity_str="T_SS_mat",sz=c(4,9))

# -------------------------------------------------
# Example 2: Transform SST_array into SS_T_mat, each
#             frame contains number 1-9
# -------------------------------------------------
(m <- array(rep(1:9,4),dim=c(3,3,4)))
intensity_format_transform(m,intensity_str="SST_array")

}
\author{
\packageAuthor{AIUQ}
}
\keyword{internal}
