% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cart2polar}
\alias{cart2polar}
\title{Transform Cartesian coordinates to polar coordinates}
\usage{
cart2polar(x, y)
}
\arguments{
\item{x}{a vector of x-coordinates}

\item{y}{a vector of y-coordinates}
}
\value{
A data frame with 2 variables, where r is the
directed distance from a point designed as the pole, and
theta represents the angle, in radians, between the pole and the point.
}
\description{
Transform ordered pair (x,y), where x and y denotes the
directed distance between the point and each of two
perpendicular lines, the x-axis and the y-axis, to polar
coordinate. Input x and y must have the same length.
}
\examples{
library(AIUQ)

# Input in Cartesian coordinates
(x <- rep(1:3,each = 3))
(y <- rep(1:3,3))

# Data frame with polar coordinates
(polar <- cart2polar(x, y))

}
\author{
\packageAuthor{AIUQ}
}
\concept{cart2pol}
\keyword{internal}
