% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_ahm.R
\name{coef.cv.ahm}
\alias{coef.cv.ahm}
\title{Coefficient method for the fitted cv.ahm object}
\usage{
\method{coef}{cv.ahm}(object, metric = "mse", ...)
}
\arguments{
\item{object}{cv.ahm object}

\item{metric}{"mse" or "aicc"}

\item{...}{not used}
}
\value{
a numerical vector
}
\description{
Coefficient method for the fitted cv.ahm object
}
\examples{
\donttest{
data("pringles_fat")
data_fat = pringles_fat
h_tmp = 1.3
x = data_fat[,c("c1","c2","c3","x11","x12","x21","x22")]
y = data_fat[,1]
powerh_path = round(seq(0.001,2,length.out =15),3)
num_major = 3; dist_minor = c(2,2,1)
res = cv.ahm (y, x, powerh_path=powerh_path, metric = "mse", num_major, dist_minor, type = "weak"
, alpha=0, lambda_seq=seq(0,5,0.01), nfolds=NULL, mapping_type = c("power"), rep_gcv=100)
coefficients = coef(res)
}

}
