% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADP.R
\name{adp.u}
\alias{adp.u}
\title{Calculates the predicted adoption probability according to the users' rate}
\source{
Kislev, Mickey M. & Kislev, Shira, (2020). The Market Trajectory of a
Radically New Product: E-Cigarettes. IJMS 12(4):63-92, DOI:\href{https://www.ccsenet.org/journal/index.php/ijms/article/view/0/44285}{10.5539/ijms.v12n4p63}
}
\usage{
adp.u(users)
}
\arguments{
\item{users}{a vector of percentige (0<users<1) of known users.}
}
\value{
a vector of predicted percentige(0<ADP<1) of the adoption probability
of a innovative product in the population.
}
\description{
This function develops a prediction of the adoption rate of an innovation in
the market, according to the number of users.
}
\details{
This function calculates the adoption probability in the population of a certain
innovation according to known users rate measured in a survey.
}
\examples{
# 50\% rate of users
adp.u(0.5)
0.6773232
# means that two out of three people who try the product will adopt it,
# in case that 50\% of the population already uses it.
}
\seealso{
\code{\link{pusers}}, \code{\link{ptriers}}, and \code{\link{adp.t}}
}
\author{
Mickey Kislev and Shira Kislev
}
