% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{ACEsearch.dump}
\alias{ACEsearch.dump}
\title{Dumps patient from ACE to a file on disk}
\usage{
ACEsearch.dump(connection, patient_id, path, selection_query = NULL,
  contains_start = FALSE, contains_end = FALSE)
}
\arguments{
\item{connection}{connection object returned from connect(url) function}

\item{patient_id}{numerical id of the patient}

\item{path}{path where to store the generated files}

\item{selection_query}{returns only the part of patient's data that intersects with the result of the selection_query}

\item{contains_start}{the dumped time interval's start has to be intersecting the selection_query}

\item{contains_end}{the dumped time interval's end has to be intersecting the selection_query}
}
\value{
data frame containing patient IDs and time intervals (optional)
}
\description{
Dumps patient from ACE to a file on disk
}
\examples{
\donttest{ACEsearch.dump(ACEsearch.connect('http://localhost:8080'), 123, '/path/to/dump/files/')}
\donttest{ACEsearch.dump(ACEsearch.connect('http://localhost:8080'), 123, '/path/', 'ICD9=250.50', TRUE, TRUE)}


}
