\name{numericSequence-class}
\alias{numericSequence-class}
\alias{Math2,numericSequence-method}
\alias{Math,numericSequence-method}
\alias{Ops,ANY,numericSequence-method}
\alias{Ops,numericSequence,ANY-method}
\alias{Ops,numericSequence,numericSequence-method}
\alias{Summary,numericSequence-method}
\alias{[,numericSequence-method}
\alias{[<-,numericSequence,ANY,ANY,ANY-method}
\alias{[[,numericSequence-method}
\alias{[[<-,numericSequence-method}
\alias{c,numericSequence-method}
\alias{coerce,integer,numericSequence-method}
\alias{coerce,numeric,numericSequence-method}
\alias{coerce,numericSequence,integer-method}
\alias{coerce,numericSequence,numeric-method}
\alias{coerce,numericSequence,character-method}
\alias{diff,numericSequence-method}
\alias{duplicated,numericSequence-method}
\alias{format,numericSequence-method}
\alias{is.na,numericSequence-method}
\alias{is.nan,numericSequence-method}
\alias{length,numericSequence-method}
\alias{length<-,numericSequence-method}
\alias{logb,numericSequence-method}
\alias{match,ANY,numericSequence-method}
\alias{match,numericSequence,ANY-method}
\alias{mean,numericSequence-method}
\alias{median,numericSequence-method}
\alias{quantile,numericSequence-method}
\alias{rep,numericSequence-method}
\alias{rev,numericSequence-method}
\alias{shiftPositions,numericSequence-method}
\alias{shiftPositions,vector-method}
\alias{show,numericSequence-method}
\alias{sort,numericSequence-method}
\alias{sort.list,numericSequence-method}
\alias{summary,numericSequence-method}
\alias{unique,numericSequence-method}
\alias{which.na,numericSequence-method}
%
\title{
  Numeric Sequence Class 
}
\docType{class}
\description{
The \code{numericSequence} class is a compact representation of a  
numeric vector in an arithemetic sequence. 
}
\section{Slots}{
  \describe{
    \item{from}{
      (\code{numeric}) the start of the sequence. 
    }
    \item{to}{
      (\code{numeric}) the end of the sequence. 
    }
    \item{by}{
      (\code{numeric}) the increment for the sequence. 
    }
    \item{length}{
      (\code{integer}) the length of the sequence. 
    }
  }
}
\details{
The \code{numericSequence} class extends the \code{positionsNumeric} class. 

Valid \code{numericSequence} objects must contain a single non-\code{NA} number in 
at least three of the four slots.  If all four are present, the \code{length} 
slot is ignored, and a warning message is generated when the sequence is used.  

If \code{length} is present and not ignored, it must 
be non-negative. (A zero-length sequence is equivalent to \code{numeric(0)}.) 
Otherwise, the sign of the \code{by} slot must agree with the sign of  
\code{(to - from)} to have a valid sequence. In particular, if \code{by} is zero, 
then \code{to} and \code{from} must be equal. The default sequence 
(generated by calling \code{numericSequence()} or  
\code{new("numericSequence")}) has length 0. 

A \code{numericSequence} can be coerced to \code{numeric} or \code{integer} using \code{as}, 
and regularly-spaced numbers can be coerced to \code{numericSequence}  
using \code{as}. This fails if the input is not a regular arithmetic  
sequence within a tolerance given by \code{timeDateOptions("ts.eps")}.  

Most operations on \code{numericSequence} objects (for example, mathematical functions,  
arithmetic, comparison operators, or subscripting) work by first coercing to a numeric  
vector, and therefore do not return \code{numericSequence} objects. 
}
\seealso{
\code{\link{numericSequence}}  function.  
}
\keyword{classes}
