% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.zoo.R
\name{as.zoo}
\alias{as.zoo}
\alias{as.zoo.zoocat}
\title{Coercion objects to class \code{zoo}}
\usage{
\method{as.zoo}{zoocat}(x, add.colname = TRUE, ...)
}
\arguments{
\item{x}{an object.}

\item{add.colname}{logical. If TRUE, column names will be added automatically.}

\item{...}{further arguments.}
}
\value{
A \code{zoo} object.
}
\description{
Coercing objects to class \code{zoo}.
}
\details{
For \code{zoomly} and \code{zoocat}, the returned \code{zoo} object will
be added column names automatically. \cr
Note that the result of \code{as.zoo} will be a \code{zooreg} object if 
the input \code{x} is inherited from \code{zooreg}.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
zc <- zoocat(x, order.by = 1991 : 1995, colattr = data.frame(month=c(2, 3, 5, 6)))
z <- as.zoo(zc)

}

