% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dgrid.R
\name{density_2d_grid}
\alias{density_2d_grid}
\title{Density plot in 2d using the grid package}
\usage{
density_2d_grid(
  zargs,
  ngrids = 25,
  ccol = NULL,
  clwd = 1,
  clty = 1,
  box = FALSE,
  box.width = 1,
  box.height = 1,
  group... = list(cex = 0.66),
  draw = FALSE,
  ...
)
}
\arguments{
\item{zargs}{argument list as passed from \code{\link{zenplot}()}}

\item{ngrids}{number of grid points in each direction. Can be scalar or
a length-2 integer vector.}

\item{ccol}{vector (which is then recycled to the appropriate length)
giving the color of the contours}

\item{clwd}{vector (which is then recycled to the appropriate length)
giving the line widths of the contours}

\item{clty}{vector (which is then recycled to the appropriate length)
giving the line types of the contours}

\item{box}{logical indicating whether a box should be drawn}

\item{box.width}{width of the box}

\item{box.height}{height of the box}

\item{group...}{list of arguments passed to group_2d_grid (or NULL)}

\item{draw}{logical indicating whether drawing should take place}

\item{...}{additional arguments passed to gpar()}
}
\value{
grob (invisibly)
}
\description{
Density plot in 2d using the grid package
}
\note{
- We use names depending on the 'type' here since otherwise, if one calls it
        once for 'p' and once for 'l', only one of them is plotted
      - The default point size was chosen to match the default of graphics
}
\seealso{
Other default 2d plot functions using the grid package: 
\code{\link{arrow_2d_grid}()},
\code{\link{axes_2d_grid}()},
\code{\link{group_2d_grid}()},
\code{\link{label_2d_grid}()},
\code{\link{points_2d_grid}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_grid}()}

Other default 2d plot functions: 
\code{\link{arrow_2d_graphics}()},
\code{\link{arrow_2d_grid}()},
\code{\link{arrow_2d_loon}()},
\code{\link{axes_2d_graphics}()},
\code{\link{axes_2d_grid}()},
\code{\link{axes_2d_loon}()},
\code{\link{density_2d_graphics}()},
\code{\link{density_2d_loon}()},
\code{\link{extract_2d}()},
\code{\link{group_2d_graphics}()},
\code{\link{group_2d_grid}()},
\code{\link{group_2d_loon}()},
\code{\link{label_2d_graphics}()},
\code{\link{label_2d_grid}()},
\code{\link{label_2d_loon}()},
\code{\link{points_2d_graphics}()},
\code{\link{points_2d_grid}()},
\code{\link{points_2d_loon}()},
\code{\link{qq_2d_graphics}()},
\code{\link{qq_2d_grid}()},
\code{\link{rect_2d_graphics}()},
\code{\link{rect_2d_grid}()},
\code{\link{rect_2d_loon}()}
}
\author{
Marius Hofert and Wayne Oldford

Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using the grid package}
