% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenpath.R
\name{indexData}
\alias{indexData}
\title{Indexing a Matrix or Data Frame According to Given Indices}
\usage{
indexData(x, indices)
}
\arguments{
\item{x}{A \code{\link{matrix}} or \code{\link{data.frame}} 
(most useful for the latter).}

\item{indices}{vector of column indices of \code{x}
(typically obtained from \code{\link{zenpath}()}).}
}
\value{
An object as \code{x} 
       (typically a \code{\link{data.frame}} or 
        \code{\link{matrix}}) containing \code{x}
        indexed by \code{indices}.
}
\description{
Indexing a Matrix or Data Frame According to Given Indices
}
\note{
Useful for constructing data.frames without .1, .2, ... in their
      names when indexing a data.frame with a zenpath.
}
\examples{
## The function is handiest for data frames
## where we want to reuse the variable names
## without adding a suffix like ".1" etc.
## For example, 
x <-  BOD  # Biochemical Oxygen Demand data in base R
indices <- rep(1:2, 2)
## now compare 
indexData(x, indices)
## to
x[, indices]
## zenplots prefer not to have the suffixes.

}
\seealso{
\code{\link{zenplot}()} which provides the zenplot.

Other tools related to constructing zenpaths: \code{\link{connect_pairs}},
  \code{\link{extract_pairs}}, \code{\link{graph_pairs}},
  \code{\link{groupData}}, \code{\link{zenpath}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{tools related to constructing zenpaths}
