% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permtest.R
\name{permtest}
\alias{permtest}
\title{Permutation test for local and global association measures}
\usage{
permtest(x, group = as.list(colnames(x$data$pp)), nb = 1000L,
  p_adjust = "BH", progress_bar = FALSE)
}
\arguments{
\item{x}{\code{\link[zebu]{lassie}} S3 object.}

\item{group}{list of column names specifying which columns
should be permuted together. This is useful for the multivariate case,
for example, when there is many dependant variables and one
independant variable. By default, permutes all columns separetely.}

\item{nb}{number of resampling iterations.}

\item{p_adjust}{multiple testing correction method.
(see \code{\link[stats]{p.adjust.methods}} for a list of methods).}

\item{progress_bar}{logical specifying if progress bar should be displayed.}
}
\value{
\code{permtest} returns an S3 object of \link[base]{class}
\code{\link[zebu]{lassie}} and \code{\link[zebu]{permtest}}.
Adds the following to the lassie object \code{x}:
\itemize{
\item global_p: global association p-value.
\item local_p: array of local association p-values.
\item global_perm: numeric global association values obtained with permutations.
\item local_perm: matrix local association values obtained with permutations. Column number correspond to positions in local association array after converting to numeric (e.g. local_perm[, 1] corresponds to local[1]).
\item perm_params: parameters used when calling permtest (nb and p_adjust).
}
}
\description{
Permutation test: statistical significance of local and
global association measures
}
\examples{
# Calling lassie on cars dataset
las <- lassie(cars)

# Permutation test using default settings
permtest(las)

}
\seealso{
\code{\link[zebu]{lassie}}
}
