% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamRunsSRPlotAllOppnAllMatches.R
\name{teamRunsSRPlotAllOppnAllMatches}
\alias{teamRunsSRPlotAllOppnAllMatches}
\title{Team batting plots runs vs SR for team against all oppositions in all matches}
\usage{
teamRunsSRPlotAllOppnAllMatches(matches,theTeam,plot=1)
}
\arguments{
\item{matches}{All matches of the team in all matches with all oppositions}

\item{theTeam}{The team for which the the batting partnerships are sought}

\item{plot}{Plot=1 (static), Plot=2(interactive)}
}
\value{
details
The data frame of the scorecard of the team in all matches against all oppositions
}
\description{
This function computes and plots runs vs SR  of a team in all matches against all
oppositions.
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get all matches between India with all oppositions
matches <-getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)

# This can also be loaded from saved file
# load("allMatchesAllOpposition-India.RData")

# Top batsman is displayed in descending order of runs
teamRunsSRPlotAllOppnAllMatches(matches,theTeam="India")

# The best England players scorecard against India is shown
teamRunsSRPlotAllOppnAllMatches(matches,theTeam="England",plot=1)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{teamBatsmenVsBowlersAllOppnAllMatchesPlot}}\cr
\code{\link{teamBatsmenPartnershipOppnAllMatchesChart}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatchesPlot}}\cr
\code{\link{teamBowlingWicketRunsAllOppnAllMatches}}
}
\author{
Tinniam V Ganesh
}
