% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batsmanRunsAgainstOpposition.R
\name{batsmanRunsAgainstOpposition}
\alias{batsmanRunsAgainstOpposition}
\title{Batsman runs against different oppositions}
\usage{
batsmanRunsAgainstOpposition(df, name= "A Leg Glance",dateRange,staticIntv=1)
}
\arguments{
\item{df}{Data frame}

\item{name}{Name of batsman}

\item{dateRange}{Date interval to consider}

\item{staticIntv}{Static or interactive -staticIntv =1 (static plot) &  staticIntv =2 (interactive  plot)}
}
\value{
None
}
\description{
This function computes and plots the mean runs scored by the batsman against different
oppositions
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the data frame for Kohli
kohli <- getBatsmanDetails(team="India",name="Kohli",dir=pathToFile)
batsmanRunsAgainstOpposition(kohli,"Kohli",dateRange)
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{batsmanFoursSixes}}\cr
\code{\link{batsmanRunsVsDeliveries}}\cr
\code{\link{batsmanRunsVsStrikeRate}}\cr
\code{\link{batsmanRunsPredict}}\cr
\code{\link{teamBatsmenPartnershipAllOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
