% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yf_collections.R
\name{yf_collection_get}
\alias{yf_collection_get}
\title{Downloads a collection of data from Yahoo Finance}
\usage{
yf_collection_get(
  collection,
  first_date = Sys.Date() - 30,
  last_date = Sys.Date(),
  do_parallel = FALSE,
  do_cache = TRUE,
  cache_folder = yf_cachefolder_get(),
  ...
)
}
\arguments{
\item{collection}{A collection to fetch data (e.g. "SP500", "IBOV", "FTSE" ).
See function \code{\link{yf_get_available_collections}} for finding all
available collections}

\item{first_date}{The first date of query (Date or character as YYYY-MM-DD)}

\item{last_date}{The last date of query (Date or character as YYYY-MM-DD)}

\item{do_parallel}{Flag for using parallel or not (default = FALSE).
Before using parallel, make sure you call function future::plan() first.
See <https://furrr.futureverse.org/> for more details.}

\item{do_cache}{Use cache system? (default = TRUE)}

\item{cache_folder}{Where to save cache files?
(default = yfR::yf_cachefolder_get() )}

\item{...}{Other arguments passed to \code{\link{yf_get}}}
}
\value{
A data frame with financial prices from collection
}
\description{
This function will use a set collection of YF data, such as index components
and will download all data from Yahoo Finance using \code{\link{yf_get}}.
}
\examples{

\donttest{
df_yf <- yf_collection_get(collection = "IBOV",
                           first_date = Sys.Date() - 30,
                           last_date = Sys.Date()
)
}

}
