% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{ycevo_data}
\alias{ycevo_data}
\title{Simulate bond data}
\usage{
ycevo_data(
  n = 40,
  b0 = 0,
  b1 = 0.05,
  b2 = 2,
  t1 = 0.75,
  t2 = 125,
  linear = -0.55,
  quadratic = 0.55,
  cubic = -0.55
)
}
\arguments{
\item{n}{Integer. Number of bonds of each maturity to simulation}

\item{b0}{Level term in yield curve equation, Defaults is 0. See
\code{Details}.}

\item{b1}{Slope term in yield curve equation, Defaults is 0.05. See
\code{Details}.}

\item{b2}{Curvature term in yield curve equation, Defaults is 2. See
\code{Details}.}

\item{t1}{Scaling parameter in yield curve equation, Defaults is 0.75. See
\code{Details}.}

\item{t2}{Scaling parameter in yield curve equation, Defaults is 125. See
\code{Details}.}

\item{linear}{Linear term in yield curve evolution, Defaults is -0.55. See
\code{Details}.}

\item{quadratic}{Quadratic term in yield curve evolution. Defaults is 0.55.
See \code{Details}.}

\item{cubic}{Cubic term in yield curve evolution. Defaults is -0.55. See
\code{Details}.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} object with 5 variables

\describe{
\item{qdate}{The quotation date of a bond in a \code{\link[=Date]{Date()}} class.}
\item{id}{The unique identifier of a bond.}
\item{price}{The price of a bond.}
\item{tupq}{The remaining time until the given cash flow in days.}
\item{pdint}{The payment amount of the cash flow.
For a non-coupon-paying bond, the only cash flow occurs on the maturity
date with a payment of 100, i.e., the face value of the bond.
For a coupon-paying bond, the stream of cash flows includes the coupon
payable on the interest payment date before maturity and the face value
100 plus the coupon payment for the last cash flow on the maturity date.}
}
}
\description{
Simulates bond transaction data at each weekday throughout the year 2023,
following the extended version of Nelson & Siegel model (Nelson, C. R., &
Siegel, A. F., 1987).
}
\details{
\code{n} bonds for each of the following maturities are simulated: 20, 10, 5,
3, 2 and 0.8 years. The face value of all bonds is 100. Bonds with 0.8 years
of maturity are similar to the US Treasury bills with no coupon. Bonds with
maturity between 2 and 10 years correspond to the US Treasury notes. Their
coupon rates are simulated from an Epanechnikov distribution with mean 4, and
the distance from the mean to the boundary is 2.65. Bonds with maturity of 20
years corresponds to the US Treasury bonds. Their coupon rates are simulated
from an Epanechnikov distribution with mean 7.5, and the distance from the
mean to the boundary is 2.65. Coupons are payable every 6 months.

We artificially "observe" quotation data of bonds on every weekday through
out 2023, starting with 2 Jan 2023. To ensure an adequate number of
transactions are observed for the estimation of the yield curve, the earliest
bond is issued prior to the beginning of 2023, determined by the length of
maturity of that type of bond, such that the last payment can still be
observed at the beginning of 2023. For example, the first bond with 20 years
of maturity is issued at the beginning of 2003. The last bond within this type
is issued at the end of 2023. The rest of the bonds have issue dates evenly
distributed between the first and the last bonds.

The initial yield at the beginning of 2023 is generated from the following
equation
\deqn{Yield_{i, 0} = b_0 + b_1 * ((1 - \exp(-\tau_i / t_1)) / (\tau / t_1)) +
b_2 * ((1 - \exp(-\tau_i / t_2)) / (\tau_i / t_2) - \exp(-\tau_i / t_2))}
where \eqn{\tau_i} is the time to maturity in years. The yield curve at
quotation time \eqn{t} is obtained by multiplying this curve by the cubic
equation, \deqn{Yield_{i, t} = Yield_{i, 0} * (1 + linear * time + quadratic *
time^2 + cubic * time^3)} so the yield curve slowly changes over different
quotation dates. The time \eqn{t} is a value between 0 and 1, the proportion
of time that has passed by a quotation date, identifying the progression
through 2023. For example, the time \eqn{t} corresponding to 31 Mar 2023 is
0.25.

The discount function is then derived from the yield curve, \deqn{d_t(\tau) =
\exp(-\tau y_t(\tau))} to discount all the future cash flows of a bond and
calculate the price of that bond at the quotation date.
}
\examples{
ycevo_data()

}
\references{
Nelson, C. R., & Siegel, A. F. (1987). Parsimonious Modeling of
Yield Curves. The Journal of Business, 60(4), 473-489.

Koo, B., La Vecchia, D., & Linton, O. (2021). Estimation of a
nonparametric model for bond prices from cross-section and time series
information. Journal of Econometrics, 220(2), 562-588.
}
\seealso{
\code{\link[=get_yield_at]{get_yield_at()}}
}
