% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logl.R
\name{logl}
\alias{logl}
\title{Calculate the multiclass cross-entropy}
\usage{
logl(y_true, y_pred)
}
\arguments{
\item{y_true}{A matrix of multiclass 0/1 indicators}

\item{y_pred}{A matrix of predicted probability of each class}
}
\value{
The value of multiclass cross entropy
}
\description{
The function \code{logl} calculates the multiclass cross entropy
}
\examples{
data(iris, package = "datasets")
Y <- iris[, 5]
X <- scale(iris[, 1:4])
pnet <- pnn.fit(x = X, y = Y)
logl(y_true = pnet$y.ind, y_pred = pnn.predict(pnet, X))
}
