% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mimic.R
\name{mimic.classified}
\alias{mimic.classified}
\title{Try To Make Classified Look Like Another Equal-length Variable}
\usage{
\method{mimic}{classified}(x, y = x, ...)
}
\arguments{
\item{x}{classified}

\item{y}{vector-like, same length as x}

\item{...}{ignored arguments}
}
\value{
classified
}
\description{
Tries to mimic another vector or factor for 'classified'.
See \code{\link{classified.default}}.
If meaningful and possible, x updates its
codelist attribute with labels from
corresponding values in y. Codes that don't occur
(i.e. unused levels) are removed from the codelist.
}
\examples{
let <- letters[1:5]
LET <- LETTERS[1:5]
int <- 0L:4L
num <- as.numeric(int)
fac <- factor(let)
css <- classified(let)

mimic(LET)
mimic(LET, let)
mimic(let, let)
mimic(num, let)
mimic(int, let)
mimic(fac, let)
mimic(css, let)
mimic(character(0))
mimic(numeric(0))
mimic(let, num)
mimic(fac, num)
mimic(css, num)
mimic(num, css)
mimic(let, css)

util <- c('knife','fork','spoon')
util
factor(util)
classified(util)
mimic(util)
mimic(factor(util))
mimic(classified(util))

x <- data.frame(let, LET)
library(dplyr)
library(magrittr)
x \%<>\% mutate(let = mimic(let, LET), LET = mimic(LET))
str(x)

}
\seealso{
Other mimic: 
\code{\link{mimic}()},
\code{\link{mimic.default}()}
}
\concept{mimic}
\keyword{internal}
