% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable.R
\name{xtable.decorated}
\alias{xtable.decorated}
\title{Create Export Table for Decorated}
\usage{
\method{xtable}{decorated}(x, style = "latex", ...)
}
\arguments{
\item{x}{decorated}

\item{style}{passed to \code{\link{footnote}}}

\item{...}{passed to \code{\link{footnote}} and \code{\link[xtable]{xtable}}}
}
\value{
class 'decorated', 'xtable','data.frame'
}
\description{
Creates an export table for decorated data.frame
by adding a footnote attribute.
}
\examples{
library(magrittr)
library(xtable)
set.seed(0)
x <- data.frame(
 auc = rnorm(100, mean = 2400, sd = 200),
 bmi = rnorm(100, mean = 20, sd = 5),
 gen = 0:1
)
x \%<>\% decorate('auc: [AUC_0-24, ng*h/mL]')
x \%<>\% decorate('bmi: [Body Mass Index, kg/m^2]')
x \%<>\% decorate('gen: [Gender, [Male: 1, Female: 0]]')
y <- xtable(x)
attr(y, 'footnote')

}
