# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'  K-Means using yakmo library
#' 
#'  @param	x		data matrix 
#'  @param	rounds		number of rounds (orthogonal views)
#'  @param	k		number of clusters
#'  @param	iter	numer of iterations in one round
#'  @param	initType		centroid initialization via Random or KMeans++
#'  @param	verbose		verbose output?
#'
#'  @return	a list consisting of
#'	centers	these are the resulting centroids of the kmean algorithm (as a std::vector of NumericMatrix)
#'	cluster 	these are the labels for the resulting clustering (as a std::vector of NumericVector)
#'	obj			this is a vector with the final objective value for each round
#'
orthoKMeansTrainCpp <- function(x, rounds = 1L, k = 3L, iter = 100L, initType = 0L, verbose = FALSE) {
    .Call('yakmoR_orthoKMeansTrainCpp', PACKAGE = 'yakmoR', x, rounds, k, iter, initType, verbose)
}

#'  K-Means prediction using yakmo library
#' 
#'  @param	x		data matrix 
#'  @param	centers	centers
#'  @param	nf		number of features
#'  @param	k		number of clusters
#'  @param	verbose		verbose output?
#'
#'  @return	a list consisting of
#'	cluster 	these are the labels for the resulting clustering, one column for each clustering
#'
orthoKMeansPredictCpp <- function(x, centers, nf, k = 0L, verbose = FALSE) {
    .Call('yakmoR_orthoKMeansPredictCpp', PACKAGE = 'yakmoR', x, centers, nf, k, verbose)
}

