% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind.plots.R
\name{ind.plots}
\alias{ind.plots}
\title{Observations (DV), individual predictions (IPRED) and population predictions
(PRED) are plotted against the independent variable for every individual in
the dataset, for Xpose 4}
\usage{
ind.plots(
  object,
  y.vals = c(xvardef("dv", new.obj), xvardef("ipred", new.obj), xvardef("pred", new.obj)),
  x.vals = xvardef("idv", new.obj),
  id.vals = xvardef("id", new.obj),
  key.text = y.vals,
  main = "Default",
  key = "Default",
  xlb = xlabel(xvardef("idv", object), object),
  ylb = NULL,
  layout = c(4, 4),
  inclZeroWRES = FALSE,
  subset = xsubset(object),
  type = "o",
  grid = FALSE,
  col = c(1, 2, 4),
  lty = c(0, 1, 3),
  lwd = c(1, 1, 1),
  pch = c(21, 32, 32),
  cex = c(0.7, 0.7, 0.7),
  fill = c("lightgrey", 0, 0),
  prompt = FALSE,
  mirror = NULL,
  main.cex = 0.9,
  max.plots.per.page = 1,
  pch.ip.sp = c(21, 19, 18),
  cex.ip.sp = c(0.7, 0.4, 0.4),
  y.vals.subset = NULL,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{y.vals}{The Y values to use.}

\item{x.vals}{The X values to use.}

\item{id.vals}{The ID values to use.}

\item{key.text}{The text in the legend to use.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{key}{Create a legend.}

\item{xlb}{A string giving the label for the x-axis. \code{NULL} if none.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{layout}{A list giving the layout of the graphs on the plot, in columns
and rows. The default is 4x4.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is
included in the plot. The default is TRUE.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{type}{1-character string giving the type of plot desired. The default
is "o", for over-plotted points and lines. See
\code{\link{xpose.plot.default}}.}

\item{grid}{Should the plots have a grid in each plot?}

\item{col}{A list of three elements, giving plotting characters for
observations, individual predictions, and population predictions, in that
order. The default is black for DV, red for individual predictions, and blue
for population predictions.}

\item{lty}{A list of three elements, giving line types for observations,
individual predictions, and population predictions, in that order.}

\item{lwd}{A list of three elements, giving line widths for observations,
individual predictions, and population predictions, in that order.}

\item{pch}{A list of three elements, giving plotting characters for
observations, individual predictions, and population predictions, in that
order.}

\item{cex}{A list of three elements, giving relative point size for
observations, individual predictions, and population predictions, in that
order. The default is c(0.7,0.7,0.7).}

\item{fill}{Fill the circles in the points?}

\item{prompt}{Specifies whether or not the user should be prompted to press
RETURN between plot pages. Default is TRUE.}

\item{mirror}{Mirror plots are not yet implemented in this function and this
argument must contain a value of \code{NULL}}

\item{main.cex}{The size of the title.}

\item{max.plots.per.page}{Maximum number of plots per page.}

\item{pch.ip.sp}{If there is a panel with just one observation then this
specifies the type of points for the DV, IPRED and PRED respectively.}

\item{cex.ip.sp}{If there is a panel with just one observation then this
specifies the size of the points for the DV, IPRED and PRED respectively.}

\item{y.vals.subset}{Used to subset on the DV, IPRED and PRED variables
separately.  Either \code{NULL} or a vector of three strings, corresponding
to the subset of DV, IPRED and PRED respectively. See examples below.}

\item{\dots}{Other arguments passed to \code{link{xpose.plot.default}}.}
}
\value{
Returns a stack of plots observations (DV) against individual
predictions (IPRED) and population predictions (PRED).

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} and \code{\link{xpose.panel.default}} for
details.
}
\description{
This is a compound plot consisting of plots of observations (DV), individual
predictions (IPRED) and population predictions (PRED) against the
independent variable for every individual in the dataset, a specific
function in Xpose 4. It is a wrapper encapsulating arguments to the
\code{xpose.plot.default} function.
}
\details{
Matrices of individual plots are presented for comparison and closer
inspection.
}
\examples{
## Here we load the example xpose database 
xpdb <- simpraz.xpdb

## Monochrome, suitable for manuscript or report
ind.plots(xpdb, 
  subset="ID>40 & ID<57", 
  col=c(1,1,1), 
  lty=c(0,2,3), 
  strip=function(..., bg) 
    strip.default(..., bg="grey"))
    
\dontrun{    
## IF we simulate in NONMEM using a dense grid of time points
## and all non-observed DV items are equal to zero.
ind.plots(xpdb,inclZeroWRES=TRUE,y.vals.subset=c("DV!=0","NULL","NULL"))


# to plot individual plots of multiple variables
ind.plots(xpdb,subset="FLAG==1")
ind.plots(xpdb,subset="FLAG==2")
}

}
\seealso{
\code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link[lattice]{strip.default}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
\keyword{methods}
