% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.vpctab.R
\name{read.vpctab}
\alias{read.vpctab}
\title{Read the vpctab file from PsN into Xpose}
\usage{
read.vpctab(
  vpctab = NULL,
  object = NULL,
  vpc.name = "vpctab",
  vpc.suffix = "",
  tab.suffix = "",
  inclZeroWRES = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{vpctab}{The vpctab file from a '\code{vpc}' run in PsN.}

\item{object}{An xpose data object. Created from \code{\link{xpose.data}}.
One of \code{object} or \code{vpctab} is required.  If both are present then
the information from the \code{vpctab} will over-ride the xpose data object
\code{object} (i.e. the values from the vpctab will replace any matching
values in the \code{object@Data} portion of the xpose data object). If only
\code{object} is present then the function will look for a vpctab with the
same run number as the one associated with the object.}

\item{vpc.name}{The default name of the vpctab file. Used if only
\code{object} is supplied.}

\item{vpc.suffix}{The suffix of the vpctab file. Used if only \code{object}
is supplied.}

\item{tab.suffix}{The table suffix of the vpctab file. Used if only
\code{object} is supplied. Final order of the file would be then
\code{paste(vpc.name,object@Runno,vpc.suffix,tab.suffix)}}

\item{inclZeroWRES}{If there are no zero valued weighted residuals in the
\code{object} then this should be \code{TRUE}.}

\item{verbose}{Text messages passed to screen or not.}

\item{\dots}{Other arguments passed to other functions.}
}
\value{
Returned is an xpose data object with vpctab information included.
}
\description{
This function read in the vpctab file created from PsN and gathers the
information needed to make a vpc plot.
}
\seealso{
\code{\link{xpose.VPC}}

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{npc.coverage}()},
\code{\link{randtest.hist}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{PsN functions}
\keyword{methods}
