% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.panel.qq.R
\name{xpose.panel.qq}
\alias{xpose.panel.qq}
\title{Default QQ panel function for Xpose 4}
\usage{
xpose.panel.qq(x, object, pch = object@Prefs@Graph.prefs$pch,
  col = object@Prefs@Graph.prefs$col, cex = object@Prefs@Graph.prefs$cex,
  abllty = object@Prefs@Graph.prefs$abllty,
  abllwd = object@Prefs@Graph.prefs$abllwd,
  ablcol = object@Prefs@Graph.prefs$ablcol,
  grid = object@Prefs@Graph.prefs$grid, ...)
}
\arguments{
\item{x}{Name(s) of the x-variable.}

\item{object}{An xpose.data object.}

\item{pch}{Plot character to use.}

\item{col}{Colour of lines and plot symbols.}

\item{cex}{Amount to scale the plotting character by.}

\item{abllty}{Line type.}

\item{abllwd}{Line width.}

\item{ablcol}{Line colour.}

\item{grid}{logical value indicating whether a visual reference grid should
be added to the graph. (Could use arguments for line type, color etc).}

\item{\dots}{Other arguments that may be needed in the function.}
}
\description{
This is the QQ panel function for Xpose 4. This is not intended to be used
outside the \code{xpose.plot.qq} function.  Most of the arguments take their
default values from xpose.data object but this can be overridden by
supplying them as argument to \code{xpose.plot.qq}.
}
\seealso{
\code{\link{xpose.plot.qq}}, \code{\link[lattice]{qqmath}},
\code{\link[lattice]{panel.qqmathline}}, \code{\link{xpose.data-class}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\keyword{methods}
