% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.cat.cont.R, R/change.cat.levels.R,
%   R/change.dv.cat.levels.R, R/change.miss.R, R/change.subset.R, R/get.doc.R,
%   R/set.doc.R
\name{change_misc_parameters}
\alias{change_misc_parameters}
\alias{change.cat.cont}
\alias{change.cat.cont<-}
\alias{change.cat.levels}
\alias{change.cat.levels<-}
\alias{change.dv.cat.levels}
\alias{change.dv.cat.levels<-}
\alias{change.miss}
\alias{change.subset}
\alias{get.doc}
\alias{set.doc}
\title{Functions changing miscellaneous parameter settings in Xpose 4}
\usage{
change.cat.cont(object, listall = TRUE, classic = FALSE,
  to.cat.vec = NULL, to.cont.vec = NULL, change.type.vec = NULL, ...)

change.cat.cont(object, listall = TRUE, classic = FALSE,
  to.cat.vec = NULL, to.cont.vec = NULL, ...) <- value

change.cat.levels(object, classic = FALSE, cat.limit = NULL, ...)

change.cat.levels(object, classic = FALSE, ...) <- value

change.dv.cat.levels(object, classic = FALSE, dv.cat.limit = NULL, ...)

change.dv.cat.levels(object, classic = FALSE, ...) <- value

change.miss(object, classic = FALSE)

change.subset(object, classic = FALSE)

get.doc(object, classic = FALSE)

set.doc(object, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{listall}{A logical operator specifying whether the items in the
database should be listed.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system. This is an internal option and need never be
called from the command line.}

\item{to.cat.vec}{A vector of strings specifying the names of the
categorical variables that should be transformed to continuous.}

\item{to.cont.vec}{A vector of strings specifying the names of the
continuous variables that should be transformed to categorical.}

\item{change.type.vec}{A vector of strings specifying the names of the
variables that should be transformed to/from continuous/categorical.}

\item{\dots}{arguments passed to other functions.}

\item{value}{This is the value that will be replaced in the xpose data
object \code{object}.  \code{value} is used in the \dQuote{replacement
function} version of these functions.  That is the form where we have
\code{function.name(object) <- value}.  If \code{value} is \code{NULL} then
the functions prompt the user for a value.  For \code{change.cat.levels},
\code{value} is the categorical limit \code{cat.limit}.  For
\code{change.dv.cat.levels}, \code{value} is the DV categorical limit
\code{dv.cat.limit}.  For \code{change.cat.cont}, \code{value} is the
\code{change.type.vec}.  See the examples below.}

\item{cat.limit}{The limit for which we treat a list of values as
categorical.  If there are \code{cat.limit} or less unique values then the
list is treated as categorical.}

\item{dv.cat.limit}{The limit for which we treat DV as categorical.  If
there are \code{dv.cat.limit} or less unique dv values then dv is treated as
categorical.}
}
\value{
An \code{\link{xpose.data}} object, except \code{get.doc}, which
returns the value of object@Doc.
}
\description{
These functions allow viewing and changing of settings relating to subsets,
categorical threshold values, documentation and numbers indicating missing
data values.
}
\section{Functions}{
\itemize{
\item \code{change.cat.cont}: allows interchange between categorical and continuous
data formats within the Xpose database. This in turn affects how plots are
drawn.

\item \code{change.cat.cont<-}: allows interchange between categorical and continuous
data formats within the Xpose database. This in turn affects how plots are
drawn.

\item \code{change.cat.levels}: change settings for the number of unique data
values required in a variable in order to define it as continuous for ordinary
variables.

\item \code{change.cat.levels<-}: change settings for the number of unique data
values required in a variable in order to define it as continuous for ordinary
variables.

\item \code{change.dv.cat.levels}: change settings for the number of unique data
values required in a variable in order to define it as continuous for the dependent variable.

\item \code{change.dv.cat.levels<-}: change settings for the number of unique data
values required in a variable in order to define it as continuous for the dependent variable.

\item \code{change.miss}: change the value to use as
'missing'.

\item \code{change.subset}: is used for setting the data item's subset field.  To
specify a subset of the data to process, you use the variable names and the
regular R selection operators. To combine a subset over two or more
variables, the selection expressions for the two variables are combined
using R's unary logical operators.

The variable names are those that are specified in the NONMEM table files
(e.g. PRED, TIME, SEX).

The selection operators are: == (equal) != (not equal) || (or) > (greater
than) < (less than)

For example, to specify that TIME less than 24 should be processed, you type
the expression: TIME < 24.

The unary logical operators are: & (and) | (or)

For example, to specify TIME less than 24 and males (SEX equal to 1), you
type the expression: TIME < 24 & SEX == 1

This subset selection scheme works on all variables, including ID numbers.

The subset selection is not entirely stable. For example, there is no check
that the user enters a valid expression, nor that the user specifies
existing variable names. An erroneous expression will not become evident
until a plot is attempted and the expression takes effect.

\item \code{get.doc}: get the documentation field in the Xpose data object.

\item \code{set.doc}: set the documentation field in the Xpose data object.
}}

\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## Change default subset
xpdb5 <- change.subset(xpdb5)

## Set documentation field
xpdb5 <- set.doc(xpdb5)
## View it
view.doc(xpdb5)

## change the categorical limit for the dv variable
change.dv.cat.levels(xpdb5) <- 10

## change the categorical limit for non DV variables
change.cat.levels(xpdb5) <- 2
## or
xpdb5 <- change.cat.levels(xpdb5,cat.levels=2)

## chnage variables from categorical to continuous
xpdb5 <- change.cat.cont(xpdb5,to.cat.vec=c("AGE"),to.cont.vec=c("SEX"))
xpdb5 <- change.cat.cont(xpdb5,change.type.vec=c("AGE","SEX"))
change.cat.cont(xpdb5) <- c("AGE","SEX")
}

}
\seealso{
\code{\link{Data}}, \code{\link{SData}}, \code{\link{subset}},
\code{\link{xpose.data}}

Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xpose4-package}}, \code{\link{xsubset}}
}
\author{
Andrew Hooker, Niclas Jonsson & Justin Wilkins
}
\keyword{methods}
