% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid_labels.R
\name{valid_labels}
\alias{valid_labels}
\title{Test the correctness of the labels.}
\usage{
valid_labels(y, k, g = NULL)
}
\arguments{
\item{y}{the label matrix}

\item{k}{the kernel matrix for the rows}

\item{g}{the kernel matrix for the columns (optional). If not available,
it takes the value \code{NULL}}
}
\value{
\code{TRUE} if all labels are compatible, an error otherwise.
}
\description{
This function checks whether the labels between the Y, K, and G
matrices make sense. This means that all the labels found as
rownames for \code{y} can be found as rownames \emph{and} column
names of \code{k}, and all the colnames for \code{y} can be found
as rownames \emph{and} colnames of \code{g} (if provided).
}
\details{
Compatible labels mean that it is unequivocally clear which
rows and columns can be linked throughout the model. In case none
of the matrices have row- or colnames, the labels are considered
compatible. In all other cases, all matrices should have both row
and column names. They should fulfill the following conditions:

\itemize{
  \item the row- and column names of a kernel matrix must contain
  the same values in the same order. Otherwise, the matrix can't
  be symmetric.
  \item the rownames of \code{y} should correspond to the rownames
  of \code{k}
  \item the colnames of \code{y} should correspond to the colnames
  of \code{g} if it is supplied, or the colnames of \code{k} in
  case \code{g} is \code{NULL}
}
}
\note{
This is a non-exported convenience function.
}
