% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BIC.constant.R
\name{BIC.constant}
\alias{BIC.constant}
\title{Bayesian Information Criterion for excess hazard model with
baseline hazard following a piecewise constant function}
\usage{
\method{BIC}{constant}(object, ...)
}
\arguments{
\item{object}{a fitted model object obtained from \code{xhaz} function}

\item{...}{optionally more fitted model objects obtained from \code{xhaz} function}
}
\value{
the value corresponds to the BIC calculated from the total
log-likelihood of the fitted model if just one object is provided.
If multiple objects are provided, a data.frame with columns corresponding to the
objects and rows representing the number of parameters in the model (df) and the BIC.
}
\description{
Calculates the Bayesian Information Criterion' for fitted
models from \code{xhaz}.
}
\examples{
library("xhaz")

# Esteve et al. model: baseline excess hazard is a piecewise function
#                      linear and proportional effects for the covariates on
#                      baseline excess hazard.


set.seed(1980)
simuData2 <- simuData[sample(nrow(simuData), size = 500), ]
fit.estv2 <- xhaz(formula = Surv(time_year, status) ~ agec + race,
                  data = simuData2,
                  ratetable = survexp.us,
                  interval = c(0, NA, NA, NA, NA, NA, 6),
                  rmap = list(age = 'age', sex = 'sex', year = 'date'),
                  baseline = "constant", pophaz = "classic")


fit.estv2

BIC(fit.estv2)

}
\keyword{internal}
