% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgx_breaks_log10.R
\name{xgx_breaks_log10}
\alias{xgx_breaks_log10}
\title{Sets the default breaks for log10}
\usage{
xgx_breaks_log10(data_range)
}
\arguments{
\item{data_range}{range of the data}
}
\value{
numeric vector of breaks
}
\description{
\code{xgx_breaks_log10} sets nice breaks for log10 scale.
it's better than the default function because it ensures there is at least 
2 breaks
and also, it will try to go by 3s (i.e. 1,3,10,30,100) if it makes sense
}
\details{
for the extended breaks function Q is a set of nice increments and
w is a set of 4 weights for:

\enumerate{
\item simplicity - how early in the Q order are you
\item coverage - labelings that don't extend outside the data: 
range(data) / range(labels)
\item density (previously granularity) - how close to the number of 
ticks do you get (default is 5)
\item legibility - has to do with fontsize and formatting to prevent 
label overlap
}
}
\examples{
xgx_breaks_log10(c(1, 1000))
xgx_breaks_log10(c(0.001, 100))
xgx_breaks_log10(c(1e-4, 1e4))
xgx_breaks_log10(c(1e-9, 1e9))
xgx_breaks_log10(c(1, 2))
xgx_breaks_log10(c(1, 5))
xgx_breaks_log10(c(1, 10))
xgx_breaks_log10(c(1, 100))
xgx_breaks_log10(c(1, 1.01))
xgx_breaks_log10(c(1, 1.0001))
print(xgx_breaks_log10(c(1, 1.000001)), digits = 10)

}
\references{
Talbot, Justin, Sharon Lin, and Pat Hanrahan. 
"An extension of Wilkinson’s 
algorithm for positioning tick labels on axes." IEEE Transactions 
on visualization and computer graphics 16.6 (2010): 1036-1043.
}
