% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateGeneBestGreedy}
\alias{xegaPermMutateGeneBestGreedy}
\title{Mutate a gene (by inserting a greedy path at start of random length k).}
\usage{
xegaPermMutateGeneBestGreedy(gene, lF)
}
\arguments{
\item{gene}{A Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A Permutation
}
\description{
\code{xegaPermMutateGeneGreedy} mutates a permutation 
             by inserting a greedy path of length \code{k} 
             at a random position \code{start}.
             The mutation rate for a gene is given by \code{MutationRate()}.
}
\details{
The path length \code{k} is expontially decaying
             with exponential decay constant \code{lF$lambda()}.
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateGeneGreedy(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGeneOrderBased}()},
\code{\link{xegaPermMutateGenekInversion}()},
\code{\link{xegaPermMutateGenekOptLK}()},
\code{\link{xegaPermMutateMix}()}
}
\concept{Mutation}
