% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpMutate.R
\name{xegaGpMutateAllGene}
\alias{xegaGpMutateAllGene}
\title{Mutate a gene.}
\usage{
xegaGpMutateAllGene(g, lF)
}
\arguments{
\item{g}{Derivation tree.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Derivation tree.
}
\description{
\code{xegaGpMutateAllGene()} 
              replaces a randomly selected subtree by
              a random derivation tree with the same root symbol 
              with small probability.
              All non-terminal nodes are considered as insertion points.
              Depth-bounds are respected.
}
\details{
Mutation is controlled by one local parameter: 
          \enumerate{
           \item \code{lF$MaxMutDepth()} controls the maximal depth of 
                 of the new random generation tree.
          }
          This version of the genetic operator skips the filter loop.
}
\examples{
gene1<-xegaGpInitGene(lFxegaGpGene)
xegaGpDecodeGene(gene1, lFxegaGpGene)
gene<-xegaGpMutateAllGene(gene1, lFxegaGpGene)
xegaGpDecodeGene(gene, lFxegaGpGene)

}
\seealso{
Other Mutation: 
\code{\link{xegaGpMutateFilterGene}()}
}
\concept{Mutation}
