% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaUCrossGene}
\alias{xegaGaUCrossGene}
\title{Uniform crossover of 2 genes.}
\usage{
xegaGaUCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{A binary gene.}

\item{gg2}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of one binary gene.
}
\description{
\code{xegaGaUCrossGene} swaps alleles of both genes
             with a probability of 0.5. It generates a random 
             mask which is used to build the new gene.
}
\examples{
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene2, lFxegaGaGene)
gene3<-xegaGaUCrossGene(gene1, gene2, lFxegaGaGene)
xegaGaDecodeGene(gene3[[1]], lFxegaGaGene)
}
\references{
Syswerda, Gilbert (1989):
  Uniform Crossover in Genetic Algorithms. 
  In: Schaffer, J. David (Ed.)
  Proceedings of the Third International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 2-9.
  (ISBN:1-55860-066-3)
}
\seealso{
Other Crossover (1): 
\code{\link{xegaGaCrossGene}()},
\code{\link{xegaGaUPCrossGene}()}
}
\concept{Crossover (1)}
