% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_funcs.R
\name{date_num}
\alias{date_num}
\title{date to number}
\usage{
date_num(x, unit = "s", origin = "1970-01-01", scientific = FALSE)
}
\arguments{
\item{x}{date.}

\item{unit}{time unit, available values including milliseconds, seconds, minutes, hours, days, weeks.}

\item{origin}{original date, defaults to 1970-01-01.}

\item{scientific}{logical, whether to encode the number in scientific format, defaults to FALSE.}
}
\description{
It converts date to numeric value in specified unit.
}
\examples{
# setting unit
date_num(Sys.time(), unit='milliseconds')
date_num(Sys.time(), unit='mil')

date_num(Sys.time(), unit='seconds')
date_num(Sys.time(), unit='s')

date_num(Sys.time(), unit='days')
date_num(Sys.time(), unit='d')

# setting origin
date_num(Sys.time(), unit='d', origin = '1970-01-01')
date_num(Sys.time(), unit='d', origin = '2022-01-01')

# setting scientific format
date_num(Sys.time(), unit='mil', scientific = FALSE)
date_num(Sys.time(), unit='mil', scientific = TRUE)
date_num(Sys.time(), unit='mil', scientific = NULL)

}
