% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{google_font}
\alias{google_font}
\title{Specify Google Font}
\usage{
google_font(family, ..., languages = NULL)
}
\arguments{
\item{family}{Font family}

\item{...}{Font weights to include, example "400", "400i"}

\item{languages}{Font languages to include (dependent on the font.) See
\code{\link[=google_language_codes]{google_language_codes()}}.}
}
\value{
A \code{"google_font"} object.
}
\description{
Builds Google Fonts URL from family name. Extra weights are given in the
\code{...} parameters. Languages can be specified in \code{langauges} and must one or
more of the language codes as given by \code{google_language_codes()}.
}
\examples{
google_font("Josefin Sans", "400", "400i", "600i", "700")
google_font("Josefin Sans", languages = c("latin-ext", "vietnamese"))
}
