% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{decktape}
\alias{decktape}
\title{Convert HTML presentations to PDF via DeckTape}
\usage{
decktape(file, output,
  args = "--chrome-arg=--allow-file-access-from-files",
  docker = Sys.which("decktape") == "", version = "", open = FALSE)
}
\arguments{
\item{file}{The path to the HTML presentation file. When \code{docker =
FALSE}, this path could be a URL to online slides.}

\item{output}{The desired output path of the PDF file.}

\item{args}{Command-line arguments to be passed to \code{decktape}.}

\item{docker}{Whether to use Docker (\code{TRUE}) or use the
\command{decktape} command directly (\code{FALSE}). By default, if
\pkg{decktape} has been installed in your system and can be found via
\code{Sys.which('decktape')}, it will be uesd directly.}

\item{version}{The \pkg{decktape} version when you use Docker.}

\item{open}{Whether to open the resulting PDF with your system PDF viewer.}
}
\value{
The output file path (invisibly).
}
\description{
This function can use either the \command{decktape} command or the hosted
docker image of the \pkg{decktape} library to convert HTML slides to PDF
(including slides produced by \pkg{xaringan}).
}
\note{
For some operating systems you may need to
  \href{https://stackoverflow.com/questions/48957195}{add yourself to the
  \command{docker} group} and restart your machine if you use DeckTape via
  Docker. By default, the latest version of the \pkg{decktape} Docker image
  is used. In case of errors, you may want to try older versions (e.g.,
  \code{version = '2.8.0'}).
}
\examples{
if (interactive()) {
    xaringan::decktape("https://slides.yihui.name/xaringan", "xaringan.pdf", 
        docker = FALSE)
}
}
\references{
DeckTape: \url{https://github.com/astefanutti/decktape}. Docker:
  \url{https://www.docker.com}.
}
