% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_gene}
\alias{xQTLquery_gene}
\title{Query basic information (including name, symbol, position and description, etc. ) of genes.}
\usage{
xQTLquery_gene(
  genes = "",
  geneType = "auto",
  gencodeVersion = "v26",
  recordPerChunk = 150
)
}
\arguments{
\item{genes}{A charater vector or a string of gene symbol, gencode id (versioned or unversioned), or a charater string of gene type.
\itemize{
\item \strong{gene symbol (Default)}.

A character string or a character vector (case ignored). like: "tp53","naDK","SDF4".
\item \strong{gencode/ensemble id} (versioned or unversioned).

A character string or a character vector (case ignored). like: "ENSG00000210195.2","ENSG00000078808".
\item \strong{gene classification}.

when "geneType" is "geneCategory", supported "genes" can be listed using function \code{gencodeGenetype$V26} or \code{gencodeGenetype$V19}

}}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{gencodeVersion}{(character) options: "v26"(default, matched with gtex_v8) or "v19"}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 150).}
}
\value{
A data.table object of queried gene information. including following columns:
\itemize{
\item \strong{genes.} Input genes
\item \strong{geneSymbol.} Gene symbol.
\item \strong{gencodeId.} Gencode/ensemble id (versioned).
\item \strong{entrezGeneId.} Entrez gene ID.
\item \strong{geneType.} Gene type.
\item \strong{chromosome.} Note: "chr" is added in gencode v26,
\item \strong{start.}
\item \strong{end.}
\item \strong{strand.}
\item \strong{tss.} Transcriptional start site.
\item \strong{gencodeVersion.} Gencode Version.
\item \strong{genomeBuild.} Genome version.
\item \strong{description.}
}
}
\description{
Query basic information (including name, symbol, position and description, etc. ) of genes.
}
\examples{
# query gene of gencode version v26/hg38
geneInfo <- xQTLquery_gene("TP53")
geneInfo <- xQTLquery_gene(c("tp53","naDK","SDF4") )
geneInfo <- xQTLquery_gene(c("ENSG00000210195.2","ENSG00000078808"))
}
