% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/master_functions.R
\name{fport_test}
\alias{fport_test}
\title{Compute Functional Hypothesis Tests}
\usage{
fport_test(
  f_data,
  test = "multi-lag",
  lag = NULL,
  iid = FALSE,
  M = NULL,
  low_disc = FALSE,
  kernel = "Bartlett",
  bandwidth = "adaptive",
  components = 3,
  bootstrap = FALSE,
  block_size = "adaptive",
  moving = FALSE,
  straps = 300,
  alpha = 0.05,
  complete_test = FALSE,
  suppress_raw_output = FALSE,
  suppress_print_output = FALSE
)
}
\arguments{
\item{f_data}{The functional data matrix with observed functions in the columns.}

\item{test}{A String specifying the hypothesis test. Currently available tests are referred to by their
string handles: "single-lag", "multi-lag", "spectral", "independence", and "imhof". Please see the Details
section of the documentation, or the vignette, for a short overview of the available tests. For a more
complete treatment of these hypothesis tests, please consult the references.}

\item{lag}{A positive integer value. Only used for the "single-lag", "multi-lag", "independence", and "imhof" tests.
This parameter specifies the single lag, or maximum lag, to be used by the specified test.}

\item{iid}{Only used for the "single-lag" and "multi-lag" tests. A Boolean value, FALSE by default. If given TRUE,
the hypothesis test will use a strong-white noise assumption (instead of a weak-white noise assumption).}

\item{M}{Only used for the "single-lag" and "multi-lag" tests. A positive Integer. Determines the number of
Monte-Carlo simulations employed in the Welch-Satterthwaite approximation of the limiting distribution of the
test statistic.}

\item{low_disc}{Only used for the "single-lag" and "multi-lag" tests. A Boolean value, FALSE by default.
If given TRUE, uses low-discrepancy sampling in the Monte-Carlo method. Note, low-discrepancy sampling will
yield deterministic results. Requires the 'fOptions' package.}

\item{kernel}{Only used for the "spectral" test. A String, 'Bartlett' by default. Specifies the kernel to be
used in the "spectral" test. Currently supported kernels are the 'Bartlett' and 'Parzen' kernels.}

\item{bandwidth}{Only used for the "spectral" test. Either a String or a positive Integer value, 'adaptive' by
default. Determines the bandwidth (or lag-window) to be used for the test. Given the string handle 'adaptive',
the bandwidth is computed via a bandwidth selection method which aims to minimize the integrated normed
error of the spectral density operator. If the given string handle is 'static', the bandwidth is computed
to be n^(1/(2q + 1)), where n is the sample size and q is the kernel order. If a positive integer is
given, that will be the bandwidth that is used.}

\item{components}{Only used for the "independence" test. A positive Integer value. Determines the number of
functional principal components to use (ranked by their importance).}

\item{bootstrap}{Only used for the "single-lag" test. A Boolean value, FALSE by default. If given TRUE, the
hypothesis test is evaluated by approximating the limiting distribution of the test statistic via a block
bootstrapping process.}

\item{block_size}{Only used for the "single-lag" test in the case when 'bootstrap' = TRUE. A positive Integer
value, with the default value being computed via the adaptive bandwidth selection method in the "spectral" test.
Determines the block size (of each block in each bootstrap sample) if the test is being bootstrapped.}

\item{moving}{Only used for the "single-lag" test in the case when 'bootstrap' = TRUE. A Boolean value, FALSE
by default If given TRUE, the performed block bootstrap will be moving rather than stationary.}

\item{straps}{Only used for the "single-lag" test in the case when 'bootstrap' = TRUE. A positive Integer with
a default value of 300. Determines the number of bootstrap samples to take if the test is being bootstrapped.}

\item{alpha}{Numeric value between 0 and 1 specifying the significance level to be used in the specified
hypothesis test. The default value is 0.05. Note, the significance value is only ever used to compute the
1-alpha quantile of the limiting distribution of the specified test's test statistic.}

\item{complete_test}{A Boolean value, FALSE by default. If TRUE, the function requires no other parameters
other than f_data, and will return a table with a single column containing p-values from an array of tests
contained in the rows.}

\item{suppress_raw_output}{A Boolean value, FALSE by default. If given TRUE, the function will not return a
list containing the p-value, quantile and statistic, and instead only prints output to the console.}

\item{suppress_print_output}{A Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the 1-alpha quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE. If 'complete-test' = TRUE, will return a 1-column table instead containing
the p-values for a variety of tests, which are given short descriptions in the index of the table.
}
\description{
\code{fport_test} Computes a variety of functional portmanteau hypothesis tests. All hypothesis tests in this
package are accessible through this function.
}
\details{
The "single-lag" portmanteau test is based on the sample autocovariance function computed from the
functional data. This test assesses the significance of lagged autocovariance operators at a single, user-specified
lag h. More specifically, it tests the null hypothesis that the lag-h autocovariance operator is equal to 0.
This test is designed for stationary functional time-series, and is valid under conditional heteroscedasticity
conditions.
The required parameter for this test are 'lag', which determines the lag at which the test is evaluated. If this
parameter is left blank, it will take a default of 1.
The optional parameters for this test are 'iid', 'M', 'low_disc', 'bootstrap', 'block_size', 'straps', 'moving',
and 'alpha'.

The "multi-lag" portmanteau test is also based on the sample autocovariance function computed from the functional
data. This test assesses the cumulative significance of lagged autocovariance operators, up to a user-selected
maximum lag K. More specifically, it tests the null hypothesis that the first K lag-h autocovariance operators
(h going from 1 to K) is equal to 0. This test is designed for stationary functional time-series, and is valid
under conditional heteroscedasticity conditions.
The required parameter for this test is 'lag', which determines the maximum lag at which the test is evaluated.
If this parameter is left blank, it will take a default of 20.
The optional parameters for this test are 'iid', 'M', 'low_disc', 'bootstrap', 'block_size', 'straps', 'moving',
and 'alpha'.

The "spectral" portmanteau test is based on the spectral density operator. It essentially measures the proximity of a
functional time series to a white noise - the constant spectral density operator of an uncorrelated series.
Unlike the "single-lag" and "multi-lag" tests, this test is not for general white noise series, and may not hold
under functional conditionally heteroscedastic assumptions.
The optional parameters for this test are 'kernel', 'bandwidth', and 'alpha'.

The "independence" portmanteau test is a test of independence and identical distribution based on a dimensionality
reduction by projecting the data onto the most important functional principal components. It is based on the
resulting lagged cross-variances. This test is not for general white noise series, and may not hold under
functional conditionally heteroscedastic assumptions.
The required parameters for this test are 'lag' and 'components'. The 'lag' parameter determines the maximum lag at
which the test is evaluated. The 'components' parameter determines the number of the most important principal
components to use (importance is determined by the proportion of the variance that is explained by the
individual principal component.)

The "imhof" portmanteau test is an analogue of the "single-lag" test. While the "single-lag" test computes the
limiting distribution of the test statistic via a Welch-Satterthwaite approximation, the "imhof" test directly
computes the coefficients of the quadratic form in Normal variables which the test statistic converges too as
the sample size goes to infinity. We warn the user that this test is extremely computationally expensive, and
is only recommended for small datasets as a means of cross-verification against the single-lag test.
The required parameter for this test is 'lag', which determines the lag at which the test is evaluated.
The "imhof" test requires the "tensorA" and "CompQuadForm" packages. Note also that the imhof test does not
return a statistic, and thus returns a list with only 2 elements if suppress_raw_output = FALSE.
}
\examples{
b <- brown_motion(250, 50)
fport_test(b, test = 'single-lag', lag = 10)
fport_test(b, test = 'multi-lag', lag = 10, alpha = 0.01)
fport_test(b, test = 'single-lag', lag = 1, M = 250, low_disc = TRUE)
fport_test(b, test = 'spectral', kernel = 'Bartlett', bandwidth = 'static', alpha = 0.05)
fport_test(b, test = 'spectral', alpha = 0.1, kernel = 'Parzen', bandwidth = 'adaptive')
fport_test(b, test = 'independence', components = 3, lag = 3)

}
\references{
[1] Kokoszka P., & Rice G., & Shang H.L. (2017). Inference for the autocovariance of a functional time series
under conditional heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.

[2] Characiejus V., & Rice G. (2019). A general white noise test based on kernel lag-window estimates of the
spectral density operator. Econometrics and Statistics, submitted.

[3] Gabrys R., & Kokoszka P. (2007). Portmanteau Test of Independence for Functional Observations.
Journal of the American Statistical Association, 102:480, 1338-1348, DOI: 10.1198/016214507000001111.

[4] Zhang X. (2016). White noise testing and model diagnostic checking for functional time series.
Journal of Econometrics, 194, 76-95.

[5] Chen W.W. & Deo R.S. (2004). Power transformations to induce normality and their applications.
Journal of the Royal Statistical Society: Series B (Statistical Methodology), 66, 117–130.
}
