% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/razorNoFilter.R
\name{razorNoFilter}
\alias{razorNoFilter}
\title{Filter based on either number of total peptides and specific peptides or number of razor petides}
\usage{
razorNoFilter(
  annot,
  speNa = NULL,
  totNa = NULL,
  minRazNa = NULL,
  minSpeNo = 1,
  minTotNo = 2,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{annot}{(matrix or data.frame) main data (may contain NAs) with (PSM-) count values for each protein}

\item{speNa}{(integer or character) indicate which column of 'annot' has number of specific peptides}

\item{totNa}{(integer or character) indicate which column of 'annot' has number of total peptides}

\item{minRazNa}{(integer or character) name of column with number of razor peptides, alternative to 'minSpeNo'& 'minTotNo'}

\item{minSpeNo}{(integer) minimum number of pecific peptides}

\item{minTotNo}{(integer) minimum total ie max razor number of peptides}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a vector of logical values if corresponding line passes filter criteria
}
\description{
\code{razorNoFilter} filters based on either a) number of total peptides and specific peptides or b) numer of razor petides.
This function was designed for filtering using a mimimum number of (PSM-) count values following the common practice to consider results with 2 or more peptide counts as reliable. 
The function be (re-)run independently on each of various questions (comparisons).
Note: Non-integer data will be truncated to integer (equivalent to  \code{floor}).
}
\examples{
set.seed(2019); datT <- matrix(sample.int(20,60,replace=TRUE), ncol=6,
  dimnames=list(letters[1:10], LETTERS[1:6])) -3
datT[,2] <- datT[,2] +2
datT[which(datT <0)] <- 0
razorNoFilter(datT, speNa="A", totNa="B")
}
\seealso{
\code{\link[wrMisc]{presenceFilt}}
}
