% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineRedBasedOnCol.R
\name{combineRedBasedOnCol}
\alias{combineRedBasedOnCol}
\title{Combine/reduce redundant lines based on specified column}
\usage{
combineRedBasedOnCol(mat, colNa, sep = ",", silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{input matrix or data.frame}

\item{colNa}{character vector (length 1) macting 1 column name (if mult only 1st will be used), in case of mult matches only 1st used}

\item{sep}{(character) separator (default=",")}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix containing the input matrix without lines considered repeated (unique-like)
}
\description{
This function works similar to \code{unique}, but it takes a matrix as input and considers one specified column to find unique instances.
It identifies 'repeated' lines of the input-matrix (or data.frame) 'mat' based on (repeated) elements in/of column with name 'colNa' (or column-number).
Redundant lines (ie repeated lines) will disappear in output.
Eg used with extracted annotation where 1 gene has many lines for different GO annotation.
}
\examples{
matr <- matrix(c(letters[1:6],"h","h","f","e",LETTERS[1:5]),ncol=3,
  dimnames=list(letters[11:15],c("xA","xB","xC")))
combineRedBasedOnCol(matr,colN="xB")
combineRedBasedOnCol(rbind(matr[1,],matr),colN="xB")
}
\seealso{
\code{\link{findRepeated}}, \code{\link{firstOfRepLines}}, \code{\link{organizeAsListOfRepl}}
}
