% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/protectSpecChar.R
\name{protectSpecChar}
\alias{protectSpecChar}
\title{Protect Special Characters}
\usage{
protectSpecChar(
  x,
  prot = c(".", "\\\\", "|", "(", ")", "[", "{", "^", "$", "*", "+", "?"),
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{character vector to be prepared for use in regular expressions}

\item{prot}{(character) collection of characters that need to be protected}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a modified character vector
}
\description{
Some characters do have a special meaning when used with regular expressions.
This concerns characters like a point, parinthesis, backslash etc.
Thus, when using \code{grep} or any related command, shuch special characters must get protected in order to get considered as they are.
}
\examples{
aa <- c("abc","abcde","ab.c","ab.c.e","ab*c","ab\\\\d")
grepl("b.", aa)             # all TRUE
grepl("b\\\\.", aa)           # manual prootection
grepl(protectSpecChar("b."), aa)
}
