% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t.testAllInd.R
\name{tTestAllVal}
\alias{tTestAllVal}
\title{t.test on all individual values against all other values}
\usage{
tTestAllVal(x, alph = 0.05, alternative = "two.sided", p.adj = NULL)
}
\arguments{
\item{x}{matrix or data.frame}

\item{alph}{(numeric) threshold alpha (passed to \code{t.test})}

\item{alternative}{(character) will be passed to \code{t.test} as argument 'alternative', may be "two.sided",..}

\item{p.adj}{(character) multiple test correction : may be NULL (no correction), "BH","BY","holm","hochberg" or "bonferroni"  (but not 'fdr' since this may be confounded with local false discovery rate), see \code{\link[stats]{p.adjust}}}
}
\value{
numeric vector with p-values or FDR (depending on argument \code{p.adj})
}
\description{
Run t.test on each indiv value of x against all its neighbours (=remaining values of same vector) in order to test if tis value is likely to belong to vector x. 
This represents a repeated leave-one-out testing. Mutiple choices for multiple testing correction are available.
}
\examples{
set.seed(2016); x1 <- rnorm(100)
allTests1 <- tTestAllVal(x1)
hist(allTests1,breaks="FD")
}
\seealso{
\code{\link[stats]{t.test}}, \code{\link[stats]{p.adjust}}
}
