% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sumtrndseason2.R
\name{show_sumtrndseason2}
\alias{show_sumtrndseason2}
\title{Plot seasonal rates of change in quarters based on average estimates for multiple window widths}
\usage{
show_sumtrndseason2(
  mod,
  justify = c("center", "left", "right"),
  win = 5:15,
  txtsz = 6,
  cols = c("lightblue", "lightgreen"),
  base_size = 11
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{justify}{chr string indicating the justification for the trend window}

\item{win}{numeric vector indicating number of years to use for the trend window}

\item{txtsz}{numeric for size of text labels inside the plot}

\item{cols}{vector of low/high colors for trends}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}
}
\value{
A \code{\link[ggplot2]{ggplot2}} plot
}
\description{
Plot seasonal rates of change in quarters based on average estimates for multiple window widths
}
\details{
This function is similar to \code{\link{show_sumtrndseason}} but results are grouped into seasonal quarters as four separate plots with a combined color scale.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
show_sumtrndseason2(mod, justify = 'center', win = 2:3)
}
\seealso{
Other show: 
\code{\link{show_sumtrndseason}()}
}
\concept{show}
